 #include <stdio.h>
 #include <string.h> 
 #include <stdlib.h>
 #include <math.h>
 #include <time.h>
 #include <windows.h>

// #define DP
 
 #ifdef DP 
    #define SPDP double
    #define Precision "32 Bit Double"
 #else
    #define SPDP float
    #define Precision "32 Bit Single"
 #endif

  void whetstones(long xtra, long xmult, int calibrate);
  void pa(SPDP t, SPDP t2);
  void po(long jj, long kk, long ll);
  void p3(SPDP t, SPDP t1, SPDP t2);
  void pout(char title[22], float ops, int type, SPDP checknum,float time, int calibrate, int section);


 static SPDP loop_time[9];
 static SPDP loop_mops[9];
 static SPDP loop_mflops[9];
 static SPDP TimeUsed;
 static SPDP mwips;
 static char headings[9][18];
 static SPDP Check;
 static SPDP results[9];
 double secs;
 LARGE_INTEGER starttime;
 char    configdata[4][200];
 char    timeday[30];

void getDetails(void)
{
   printf (" Enter basic ID information for CPU, OS and other\n\n");
   printf ("Operating System:   ");
   gets(configdata[0]);
   printf ("CPU  Details        ");
   gets(configdata[1]);
   printf ("Other Informations  ");
   gets(configdata[2]);
}

void local_time()
{
    time_t time_of_day;
    time_of_day = time( NULL ); 
    strcpy (timeday, ctime(&time_of_day)); // timeday = date and time
    return;
}

void start_time()
{
    QueryPerformanceCounter(&starttime);
}

void end_time()
{
    LARGE_INTEGER liDiff;
    LARGE_INTEGER liFreq;

    QueryPerformanceCounter(&liDiff);

    liDiff.QuadPart -= starttime.QuadPart;

    (void)QueryPerformanceFrequency(&liFreq);

    secs = (double)liDiff.QuadPart / (double) liFreq.QuadPart;
} 


 #define vector 256   // 256
 #define vector_array 1208
  
  SPDP e1[4][vector_array];
  SPDP x[vector_array];
  SPDP y[vector_array];
  SPDP z[vector_array];    
  long j[vector_array];
  long k[vector_array];
  long l[vector_array];
            
int main(int argc, char *argv[])
{
       int count = 10, calibrate = 1;
       long xtra=1;
       int endit,section;
       long xmult = 2;
       int duration = 100;
       FILE    *outfile;
       int i;

       local_time();
       printf("\n %s Precision C++ Whetstone Vector Benchmark Vector Length %d \n\n", Precision, vector);
       outfile = fopen("whets.txt","a+");
       if (outfile == NULL)
       {
           printf ("Cannot open results file \n\n");
           printf("Press any key\n");
           endit = getchar();
           exit (0);
       }

    getDetails();

    printf("\n ##########################################\n\n"); 

    printf("Calibrate****\n");
         
  do
   {
    TimeUsed=0;
            
    whetstones(xtra,xmult,calibrate);
            
    printf("%11.2f Seconds %10.0lf   Passes (x 100)\n",TimeUsed,(SPDP)(xtra));
    calibrate++;
    count--;

    if (TimeUsed > 2.0)
      {
       count = 0;
      }
       else
      {
       xtra = xtra * 5;
      }
   }
   
   while (count > 0);
       
   if (TimeUsed > 0) xtra = (long)((SPDP)(duration * xtra) / TimeUsed);
   if (xtra < 1) xtra = 1;
       
   calibrate = 0;

      printf("\nUse %d  passes (x %d)\n", xtra,xmult);
      fprintf(outfile, "\n ##########################################\n\n"); 

      
       printf("\n %s Precision C++ Whetstone Vector Benchmark Vector Length %d\n", Precision, vector);
       printf("\nLoop content                  Result              MFLOPS "
                                "     MOPS   Seconds\n\n");

       TimeUsed=0;
       whetstones(xtra,xmult,calibrate);

       printf("\nMWIPS            ");
       if (TimeUsed>0)
         mwips=vector * xtra * xmult / (10 * TimeUsed);
       else
         mwips = 0;
       
       printf("%39.3f%19.3f\n\n",mwips,TimeUsed);
     
       if (Check == 0)
          printf("Wrong answer  \n");
          

    local_time();

    fprintf (outfile, " Whetstone Vector Benchmark %s Precision, %s\n", Precision, timeday);
    fprintf (outfile, " Vector length %d\n\n", vector);

    fprintf (outfile,"Loop content                   Result"
            "              MFLOPS      MOPS   Seconds\n\n"); 

    for (section=1; section<9; section++)
     {
        fprintf (outfile, "%s  %24.17f   ", headings[section],
                                              results[section]);
        if (loop_mops[section] == 99999)
         {          
            fprintf (outfile,"  %9.3f           %9.3f\n",
             loop_mflops[section], loop_time[section]);
         }
         else
         {       
            fprintf (outfile, "            %9.3f %9.3f\n",
             loop_mops[section], loop_time[section], results[section]);
         }
     }
    fprintf (outfile, "\nMWIPS             ");
    fprintf (outfile, "%39.3f%20.3f\n\n",mwips,TimeUsed);

      fprintf(outfile, "\n ##########################################\n\n"); 
      fprintf(outfile, " Whetstone Vector Benchmark %s Precision, %s\n", Precision, timeday);
      fprintf(outfile, " Entered Information\n\n"); 

       for (i=0; i<3; i++)
       {
          fprintf(outfile, " %s\n", configdata[i]);
       }

    fflush(outfile);
    fclose(outfile);



    printf("\nResults are in file Whets.txt\n\n");
    printf("Press any key\n");
     
    endit = getchar();

 return 0;             
}




    void whetstones(long xtra, long xmult, int calibrate)
    {
        long n1,n2,n3,n4,n5,n6,n7,n8,i,ix,n1mult;
        long jj, kk, ll, v;
        float timea,timeb;        


        SPDP t =  0.49999975;
        SPDP t0 = t;
        SPDP t1 = 0.50000025;
        SPDP t2 = 2.0;
        
        Check=0.0;
       
        n1 = 12*xmult;
        n2 = 14*xmult;
        n3 = 345*xmult;
        n4 = 210*xmult;
        n5 = 32*xmult;
        n6 = 899*xmult;
        n7 = 616*xmult;
        n8 = 93*xmult;
        n1mult = 10;

        /* Section 1, Array elements */

        for (v=0; v<vector; v++)
          {
                e1[0][v] = 1.0;
                e1[1][v] = -1.0;
                e1[2][v] = -1.0;
                e1[3][v] = -1.0;
          }
       start_time();

         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n1*n1mult; i++)
                  {
                    for (v=0; v<vector; v++)
                       { 
                         e1[0][v] = (e1[0][v] + e1[1][v] + e1[2][v] - e1[3][v]) * t;
                         e1[1][v] = (e1[0][v] + e1[1][v] - e1[2][v] + e1[3][v]) * t;
                         e1[2][v] = (e1[0][v] - e1[1][v] + e1[2][v] + e1[3][v]) * t;
                         e1[3][v] = (-e1[0][v] + e1[1][v] + e1[2][v] + e1[3][v]) * t;
                       }
                  }
                t = 1.0 - t;
              }
            t =  t0;                    
         }
        end_time();
        secs = secs/(SPDP)(n1mult);

        for (v=0; v<vector; v++)
         {
            if (e1[3][v] != e1[3][0])
              printf("e1[3][%d] was %20.17e not %20.17e\n",
                   v, e1[3][v],e1[3][0]);
         }

        pout("N1 floating point\0",(float)(n1*16)*(float)xtra,1,e1[3][1],secs,calibrate,1);

       start_time();
         {
            for (ix=0; ix<xtra; ix++)
              { 
                for(i=0; i<n2; i++)
                  {
                     pa(t,t2);
                  }
                t = 1.0 - t;
              }
            t =  t0;
         }
        end_time();
        for (v=0; v<vector; v++)
         {
            if (e1[3][v] != e1[3][0])
              printf("e1[3][%d] was %20.17e not %20.17e\n",
                   v, e1[3][v],e1[3][0]);
         }
        pout("N2 floating point\0",(float)(n2*96)*(float)xtra, 1,e1[3][1],secs,calibrate,2);

        /* Section 3, Conditional jumps */
        for (v=0; v<vector; v++)
           {
             j[v] = 1;
           }
        start_time();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n3; i++)
                  {
                    for (v=0; v<vector; v++)
                       {
                         if(j[v]==1)       j[v] = 2;
                         else           j[v] = 3;
                         if(j[v]>2)        j[v] = 0;
                         else           j[v] = 1;
                         if(j[v]<1)        j[v] = 1;
                         else           j[v] = 0;
                       }
                  }
              }
         }
        end_time();

        for (v=0; v<vector; v++)
         {
            if (j[v] != j[0])
              printf("j[%d] was %20.17e not %20.17e\n",
                   v, (float) (j[v]), (float) (j[0]));
         }

 
       pout("N3 if then else  \0",(float)(n3*3)*(float)xtra, 2,(float)j[1],secs,calibrate,3);

        /* Section 4, Integer arithmetic */
        for (v=0; v<vector; v++)
           {
             j[v] = 1;
             k[v] = 2;
             l[v] = 3;
           }
           kk = 2;
           ll = 3;
       start_time();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n4; i++)
                  {
                     for (v=0; v<vector; v++)
                       {
                         j[v] = j[v] *(k[v]-j[v])*(l[v]-k[v]);
                         k[v] = l[v] * k[v] - (l[v]-j[v]) * k[v];
                         l[v] = (l[v]-k[v]) * (k[v]+j[v]);
                         e1[ll-2][v] = j[v] + k[v] + l[v];
                         e1[kk-2][v] = j[v] * k[v] * l[v];
                       }
                  }
              }
         }
        end_time();
        
        for (v=0; v<vector; v++)
         {
            if (e1[0][v] != e1[0][0])
              printf("e1[0][%d] was %20.17e not %20.17e\n",
                   v, e1[0][v],e1[0][0]);
         }

        x[1] = e1[0][1]+e1[1][1];

        pout("N4 fixed point   \0",(float)(n4*15)*(float)xtra, 2,x[1],secs,calibrate,4);
     
        /* Section 5, Trig functions */
        for (v=0; v<vector; v++)
           {
               x[v] = 0.5;
               y[v] = 0.5;
           }
        
       start_time();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=1; i<n5; i++)
                  {
                    for (v=0; v<vector; v++)
                      {   
                         x[v] = t*atan(t2*sin(x[v])*cos(x[v])/(cos(x[v]+y[v])+cos(x[v]-y[v])-1.0));
                         y[v] = t*atan(t2*sin(y[v])*cos(y[v])/(cos(x[v]+y[v])+cos(x[v]-y[v])-1.0));
                      }
                  }
                t = 1.0 - t;
              }
            t = t0;
         }
        end_time();

        for (v=0; v<vector; v++)
         {
            if (y[v] != y[0])
              printf("y[%d] was %20.17e not %20.17e\n",
                   v, y[v], y[0]);
         }

        pout("N5 sin,cos etc.  \0",(float)(n5*26)*(float)xtra, 2,y[1],secs,calibrate,5);

        //Section 6, Procedure calls 
        for (v=0; v<vector; v++)
          { 
             x[v] = 1.0;
             y[v] = 1.0;
             z[v] = 1.0;
          }
       start_time();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n6; i++)
                  {
                   p3(t,t1,t2);
                  }
              }
         }
        end_time();
        
        for (v=0; v<vector; v++)
         {
            if (z[v] != z[0])
              printf("z[%d] was %20.17e not %20.17e\n",
                   v, z[v], z[0]);
         }
        
        pout("N6 floating point\0",(float)(n6*6)*(float)xtra,1,z[1],secs,calibrate,6);
  
        // Section 7, Array refrences
        jj = 0;
        kk = 1;
        ll = 2;
        for (v=0; v<vector; v++)
          {
              e1[0][v] = 1.0;
              e1[1][v] = 2.0;
              e1[2][v] = 3.0;
          }
        
       start_time();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0;i<n7;i++)
                  {
                     po(jj,kk,ll);
                  }
              }
         }
        end_time();

        for (v=0; v<vector; v++)
         {
            if (e1[2][v] != e1[2][0])
              printf("e1[2][%d] was %20.17e not %20.17e\n",
                   v, e1[2][v],e1[2][0]);
         }
       
        pout("N7 assignments   \0",(float)(n7*3)*(float)xtra,2,e1[2][1],secs,calibrate,7);
        
        // Section 8, Standard functions 
        for (v=0; v<vector; v++)
          {       
            x[v] = 0.75;
          }
        
       start_time();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n8; i++)
                  {
                    for (v=0; v<vector; v++)
                      {                     
                         x[v] = sqrt(exp(log(x[v])/t1));
                      }
                  }
              }
         }
        end_time();

        for (v=0; v<vector; v++)
         {
            if (x[v] != x[0])
              printf("x[%d] was %20.17e not %20.17e\n",
                   v, x[v], x[0]);
         }
        
        pout("N8 exp,sqrt etc. \0",(float)(n8*4)*(float)xtra, 2,x[1],secs,calibrate,8);

        return;
    }

    void pa(SPDP t, SPDP t2)
      {
         long jj,v;
         for(jj=0;jj<6;jj++)
            {
              for (v=0; v<vector; v++)
                 {
                    e1[0][v] = (e1[0][v]+e1[1][v]+e1[2][v]-e1[3][v])*t;
                    e1[1][v] = (e1[0][v]+e1[1][v]-e1[2][v]+e1[3][v])*t;
                    e1[2][v] = (e1[0][v]-e1[1][v]+e1[2][v]+e1[3][v])*t;
                    e1[3][v] = (-e1[0][v]+e1[1][v]+e1[2][v]+e1[3][v])/t2;
                 }
            }

         return;
      }

    void po(long jj, long kk, long ll)
      {
         long v;
         for (v=0; v<vector; v++)
           {
              e1[jj][v] = e1[kk][v];
              e1[kk][v] = e1[ll][v];
              e1[ll][v] = e1[jj][v];
           }
         return;
      }

     void p3(SPDP t, SPDP t1, SPDP t2)
      {
         long v;
         for (v=0; v<vector; v++)
           {          
              x[v] = y[v];
              y[v] = z[v];
              x[v] = t * (x[v] + y[v]);
              y[v] = t1 * (x[v] + y[v]);
              z[v] = (x[v] + y[v])/t2;
           }
         return;
      }

    void pout(char title[22], float ops, int type, SPDP checknum, float time, int calibrate, int section)
      {
        float mops,mflops;

        Check = Check + checknum;
        loop_time[section] = time;
        strcpy (headings[section],title);
        TimeUsed =  TimeUsed + time;
        if (calibrate == 1)
     
          {
              results[section] = checknum;
          }
        if (calibrate == 0)
          {              
            printf("%s %24.17f    ",headings[section],results[section]);    
       
            if (type == 1)
             {
                if (time>0)
                 {
                    mflops = vector*ops/(1000000L*time);
                 }
                else
                 {
                   mflops = 0;
                 }
                loop_mops[section] = 99999;
                loop_mflops[section] = mflops;
                printf(" %9.3f          %9.3f\n",
                 loop_mflops[section], loop_time[section]);                
             }
            else
             {
                if (time>0)
                 {
                   mops = vector*ops/(1000000L*time);
                 }
                else
                 {
                   mops = 0;
                 }
                loop_mops[section] = mops;
                loop_mflops[section] = 0;                 
                printf("           %9.3f%9.3f\n",
                 loop_mops[section], loop_time[section]);
             }
          }
          
        return;
      }


